<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SMS Test Sayfası</title>
    <style>
        body { font-family: Arial, sans-serif; display: flex; justify-content: center; align-items: center; height: 100vh; margin: 0; }
        .container { text-align: center; }
        button { padding: 10px 20px; font-size: 16px; cursor: pointer; }
        #result { margin-top: 20px; font-weight: bold; white-space: pre-wrap; text-align: left; }
    </style>
</head>
<body>
    <div class="container">
        <h1>SMS Test Sayfası</h1>
        <button id="sendSms">Test SMS Gönder</button>
        <pre id="result"></pre>
    </div>

    <script>
    document.getElementById('sendSms').addEventListener('click', function() {
        fetch('/test_sms', {
            method: 'POST',
        })
        .then(response => {
            if (!response.ok) {
                return response.text().then(text => { throw new Error(text) });
            }
            return response.json();
        })
        .then(data => {
            document.getElementById('result').textContent = JSON.stringify(data, null, 2);
        })
        .catch(error => {
            console.error('Error:', error);
            document.getElementById('result').textContent = 'Bir hata oluştu: ' + error.message;
        });
    });
    </script>
</body>
</html>